package com.tomi;

import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.TimeUnit;

import org.junit.jupiter.api.Test;

class Test1 {

	/**
	 * {@link HttpClient}̃Tv
	 */
	
	@Test
	void test() {

		HttpClient hc = HttpClient.newHttpClient();
		
		HttpRequest req = HttpRequest.newBuilder()
							.uri(URI.create("https://httpbin.org/get"))
							.GET()
							.setHeader("Content-Type","application/json")
							.build();

		hc.sendAsync(req, HttpResponse.BodyHandlers.ofString())
			.thenApply(HttpResponse::body)
			.thenAccept(body ->{ System.out.println( "SHOW Response:\n" + body );});

		try {
			TimeUnit.SECONDS.sleep(3);
		}
		catch(InterruptedException e) {}

		req = HttpRequest.newBuilder()
				.uri(URI.create("https://httpbin.org/post"))
				.POST(HttpRequest.BodyPublishers.ofString(
				"""
				{ "name": "anonymous","age": "12","gender": "Female"}
						"""))
				.setHeader("Content-Type","application/json")
				.build();

		hc.sendAsync(req, HttpResponse.BodyHandlers.ofString())
		.thenApply(HttpResponse::body)
		.thenAccept(body ->{ System.out.println( "SHOW Response:\n" + body );});
	
		try {
			TimeUnit.SECONDS.sleep(3);
		}
		catch(InterruptedException e) {}
		
	}
	@Test
	public void test2() {
		LocalDate ld = LocalDate.of(2021,1,21);
		
		System.out.printf( "ld = %02d/%02d/%02d\n", ld.getYear(), ld.getMonthValue(), ld.getDayOfMonth() );
		
		System.out.printf( "%s {܂ł̓t = %d\n",
				ld.format(DateTimeFormatter.ofPattern("yyyy/MM/dd")),
				ChronoUnit.DAYS.between(ld, LocalDate.now()));
		
		LocalDateTime ldt = LocalDateTime.parse("2022-03-13 22:10:00", DateTimeFormatter.ofPattern("yyy-MM-dd HH:mm:ss"));
		System.out.println( "2022-3-13 22:10:00LocalDateTime=>"+ ldt.format(DateTimeFormatter.ofPattern("yyy-MM-dd HH:mm:ss")));

	}
}