package com.tomi.http;

import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;

import org.junit.jupiter.api.Test;

class AsyncRequestTest {

	@Test
	void testAsyncFuture() {
		HttpClient hc = HttpClient.newHttpClient();
		
		HttpRequest req = HttpRequest.newBuilder()
							.header("User-Agent", "The maikurosofuto intarnetto ekusupuroura [1.0]")
							.uri(URI.create("https://httpbin.org/delay/5"))
							.GET()
							.setHeader("Content-Type","application/json")
							.build();

		CompletableFuture<HttpResponse<String>>responseFuture = 
				hc.sendAsync(req, HttpResponse.BodyHandlers.ofString());

		System.out.println( "Receive start....");
		long start = System.currentTimeMillis();
		try {
			System.out.println(responseFuture.get().body());
			System.out.println( "Receive complete...." + (System.currentTimeMillis() -start) + "msec");
		}
		catch(ExecutionException|InterruptedException e) {
			e.printStackTrace();
		}
	}
	@Test
	void testAsyncFutureAsBytes() {
		HttpClient hc = HttpClient.newHttpClient();
		
		HttpRequest req = HttpRequest.newBuilder()
							.header("User-Agent", "The maikurosofuto intarnetto ekusupuroura [1.0]")
							.uri(URI.create("https://httpbin.org/delay/5"))
							.GET()
							.setHeader("Content-Type","application/json")
							.build();

		CompletableFuture<HttpResponse<byte[]>>responseFuture = 
				hc.sendAsync(req, HttpResponse.BodyHandlers.ofByteArray());


		System.out.println( "30 day is" + Duration.ofDays(30).get(ChronoUnit.SECONDS) );
		System.out.println( "Receive start....");
		long start = System.currentTimeMillis();
		try {
			System.out.println(responseFuture.get().body());
			System.out.println( "Receive complete...." + (System.currentTimeMillis() -start) + "msec");
		}
		catch(ExecutionException|InterruptedException e) {
			e.printStackTrace();
		}
	}
}
